/******************************************************************************
 *
 * si4351.c - Driver for the Silicon Labs si5351 Frequency synthesizer
 *  Interfaces the TI tiva C Launchpad with the Silicon Labs si5351 frequency
 *  synthesizer
 *
 *  \note Used to generate the ADC CLK on the GTBE-TM4C1294XL
 *	\note The
 *
******************************************************************************/

#include <stdbool.h>
#include <stdint.h>
#include "inc/hw_memmap.h"

// Tivaware
#include "driverlib/rom.h"
#include "driverlib/i2c.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"

// GTBE Lib
#include "si5351.h"

/**
 * Initializes the synthesizer
 * \parameter synthEN enables or disables the synthesizer outputs
 **/
void synth_init(bool synthEN) {
	if(synthEN) {
		synth_initADCreclkENL(false);
	}
	else {
		// Disable synth
		synth_initADCreclkENL(true);
		synth_outputDisable();
	}

}

//void synth_outputDisable(void) {

//}

/**
 * Initializes the synthesizer I2C serial interface
 **/
void synth_initI2C(void) {
	I2CMasterInitExpClk(SYNTH_I2C_BASE, SysCtlClockGet(), false);
	I2CMasterSlaveAddrSet(SYNTH_I2C_BASE, SYNTH_I2C_SLAVE_ADDRESS, false);
}

void synth_initializeSynthesizerRegs(void) {
	//I2CMasterDataPut();
	//I2CMasterControl();
}

/**
 * Initializes ~ADC_RECLK_ENL to enable (false) or disable (true) the reclking of the
 * ADC output to the synthesizer clock.
 * \parameter bEnable Active low enable signal for the D flip-flop that reclocks the
 * ADC input when using the synthesizer to clock the ADC.
 **/
  void synth_initADCreclkENL(bool bEnable) {
	 ROM_SysCtlPeripheralEnable(SYNTH_ADC_RECLK_ENL_GPIO_PERIPH);
	 ROM_GPIOPinTypeGPIOOutput(SYNTH_ADC_RECLK_ENL_GPIO_BASE, SYNTH_ADC_RECLK_ENL_PIN);
	 if(bEnable) {
		 ROM_GPIOPinWrite(SYNTH_ADC_RECLK_ENL_GPIO_BASE, SYNTH_ADC_RECLK_ENL_PIN, 0);
	 }
	 else {
		 ROM_GPIOPinWrite(SYNTH_ADC_RECLK_ENL_GPIO_BASE, SYNTH_ADC_RECLK_ENL_PIN, SYNTH_ADC_RECLK_ENL_PIN);
	 }
  }
